import {
    View,
    Text,
    Pressable,
    TouchableOpacity,
    StyleSheet,
} from "react-native";
import React from "react";
import { myWishlistStyles } from "./MyWishlistStyle";
import { useNavigation } from "@react-navigation/native";
import ProgressiveImage from "../../src/components/ProgressiveImage";
import dpr from "../Utilities/CustomStyleAttribute/dpr";
import { itemDetailsStyles } from "../Home/FeaturedProducts/ProductDetails/ItemDetails/ItemDetailsStyle";
import DeleteIcon from "../../assets/svgs/my wishlist/delete icon.svg";
import { PRODUCT_DETAILS } from "../../components/Navigation/RouteNames";
import CustomSVG from "../../src/components/CustomSVG/CustomSVG";

const SingleWishlist = ({ item, handleWishlistDelete }) => {
    const navigation = useNavigation();
    const {
        line_items: {
            name,
            regular_price_formatted,
            sale_price_formatted,
            featured_image,
            slug,
        } = {},
        id = {},
    } = item;
    return (
        <View style={myWishlistStyles.singleWishlistContainer}>
            <Pressable
                style={myWishlistStyles.wishlistDetails}
                onPress={() => {
                    navigation.navigate(PRODUCT_DETAILS, {
                        slug,
                        item: item?.line_items
                    });
                }}
            >
                <View style={myWishlistStyles.imageCont}>
                    <ProgressiveImage
                        source={{ uri: featured_image }}
                        style={myWishlistStyles.image}
                    />
                </View>
                <View style={styles.name}>
                    <Text style={myWishlistStyles.text} numberOfLines={2}>
                        {name}
                    </Text>

                    <View style={styles.priceFormatCont}>
                        {(sale_price_formatted || regular_price_formatted) && (
                            <Text style={styles.priceFormat}>
                                {sale_price_formatted ||
                                    regular_price_formatted}
                            </Text>
                        )}
                        {sale_price_formatted && regular_price_formatted && (
                            <Text style={itemDetailsStyles.discount}>
                                {regular_price_formatted}
                            </Text>
                        )}
                    </View>
                </View>
            </Pressable>
            <TouchableOpacity
                onPress={() => handleWishlistDelete(id)}
                style={styles.deleteIcon}
            >
                <CustomSVG svgIcon={DeleteIcon} height={dpr(18)} width={dpr(18)} fill={"#898989"} />
            </TouchableOpacity>
        </View>
    );
};

export default SingleWishlist;

const styles = StyleSheet.create({
    name: {
        width: dpr("wf") - dpr(160)
    },
    deleteIcon: {
        marginTop: dpr(15)
    },
    priceFormatCont: {
        flexDirection: "row",
        paddingVertical: dpr(0),
        borderBottomWidth: 0,
    },
    priceFormat: {
        fontFamily: "DMSans_700Bold",
        color: "#FF6B00",
        fontSize: dpr(16),
        color: "#2C2C2C",
    }
});
